﻿var backupMode;
var language;
var BACKUP_DISABLED = 0;
var BACKUP_1_1 = 1;
var BACKUP_1_N = 2;
var SYSTEM_SWITCH_CONDITION = 3;
var i;
var id;
var IdStr;
var deviceBckupMode;
var switchCondInpVal;
var switchCondOutpVal;

var bck_mode_set = 0;
var bck_pair_set = new Array(0, 0);
var main_card_set = new Array(0, 0, 0);
var switch_cond_set = new Array(SYSTEM_SWITCH_CONDITION);
var switch_cond_inp_set = 0;
var switch_cond_outp_set = 0;

for(i=0; i<SYSTEM_SWITCH_CONDITION; i++)
{
	switch_cond_set[i] = 0;
}

function mouseOverSyn(obj)
{
	if(obj.disabled == false)
	{
		obj.style.background = "url(../images/btn3_hover.png)";
	}
}
function mouseOutSyn(obj)
{
	if(obj.disabled == false)
	{
		obj.style.background = "url(../images/btn3_normal.png)";
	}
}

function disableBckupBtn(pairIndex, boolValue)
{
	if(pairIndex == 3)
	{
		id = "_1_n";
	}
	else
	{
		id = pairIndex;
	}
	
	disabledButton(document.getElementById("bckup_enable" + id), boolValue);
	disabledButton(document.getElementById("sync_param" + id), boolValue);
	disabledButton(document.getElementById("revert" + id), boolValue);
}

function disabledBackup11(boolValue)
{
	if(boolValue)
	{
		for(i=0; i<2; i++)
		{
			id = i + 1;
			disableBckupBtn(id, true);
			document.getElementById("backup_pair" + id).disabled = true;
		}
	}
	else
	{
		for(i=0; i<2; i++)
		{
			id = i + 1;
			if(document.getElementById("backup_pair" + id).checked == true)
			{
				disableBckupBtn(id, false);
			}
			document.getElementById("backup_pair" + id).disabled = false;
		}
	}
}

function disabledBackup1N(boolValue)
{
	document.getElementById("main_card1").disabled = boolValue;
	document.getElementById("main_card2").disabled = boolValue;
	document.getElementById("main_card3").disabled = boolValue;
	
	for(i=0; i<3; i++)
	{
		id = i + 1;
		var cnt = 0;
		if(document.getElementById("main_card" + id).checked == true)
		{
			cnt++;
			break;
		}
	}
	
	if((!boolValue) && (cnt != 0))
	{
		disableBckupBtn(3, false);
	}
	else
	{
		disableBckupBtn(3, true);
	}
}

function disableSwitchCond(boolValue)
{
	for(i = 0; i < SYSTEM_SWITCH_CONDITION; i++)
	{
		id = i + 1;
		document.getElementById("switch_condition" + id).disabled = boolValue;
	}
	
	for(i = 0; i < switchCondInp.length; i++)
	{
		switchCondInp[i].disabled = boolValue;
	}
	
	for(i = 0; i < switchCondOutp.length; i++)
	{
		switchCondOutp[i].disabled = boolValue;
	}
}

function disablebckfield(bckMode)
{
	if(bckMode == BACKUP_DISABLED)
	{
		disabledBackup11(true);
		disabledBackup1N(true);	
		disableSwitchCond(true);	
	}
	else if(bckMode == BACKUP_1_1)
	{
		disabledBackup11(false);
		disabledBackup1N(true);	
		disableSwitchCond(false);	
	}
	else
	{
		disabledBackup11(true);
		disabledBackup1N(false);
		disableSwitchCond(false);	
	}
}

function bckModeChange(bckMode)
{
	bck_mode_set = 1;
	disablebckfield(bckMode);
}

function GetCardBackup()
{
	var xmlhttp = false;
	var backupCardInfo;
	var count = 0;
	xmlhttp = getHTTPObject();
	var getParams = "type=26&cmd=1&getCardBackup=1&language=" + language;

	xmlhttp.open("POST", "/goform/formIPQAM", true);
	if((bd.browser != "IE") && (language == 1))
	{
		xmlhttp.overrideMimeType("text/html;charset=gb2312");
	}
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			if((bd.browser == "IE") && (language == 1))
			{
				backupCardInfo = gb2utf8(xmlhttp.responseBody);
				var index = backupCardInfo.indexOf("</html>");
				var bias = backupCardInfo.length - index;
				backupCardInfo = backupCardInfo.slice(7, - bias).split("&");
			}
			else
			{
				backupCardInfo = xmlhttp.responseText.slice(7, -8).split("&");
			}

			for(i = 0; i < backupMode.length; i++)
			{
				if(backupMode[i].value == backupCardInfo[count])
				{
					backupMode[i].checked = true;
					break;
				}
			}
			disablebckfield(backupCardInfo[count]);
			count++;

			for(i = 0; i < 2; i++)
			{
				id = i + 1;
				if(backupCardInfo[count++] == 1)
				{
					document.getElementById("backup_pair" + id).checked = true;
					disableBckupBtn(id, false);
				}
				else
				{
					document.getElementById("backup_pair" + id).checked = false;
					disableBckupBtn(id, true);
				}
				
				if(backupCardInfo[count++] == 1)
				{
					if(language == 0)
					{
						document.getElementById("bckup_enable" + id).value = "Disabled";
					}
					else
					{
						document.getElementById("bckup_enable" + id).value = "不使能";
					}
				}
				else
				{
					if(language == 0)
					{
						document.getElementById("bckup_enable" + id).value = "Enabled";
					}
					else
					{
						document.getElementById("bckup_enable" + id).value = "使能";
					}
				}
				
				document.getElementById("bac_status" + id).innerHTML = backupCardInfo[count++];
			}
						
			for(i = 0; i < 3; i++)
			{
				id = i + 1;
				if(backupCardInfo[count++] == 1)
				{
					document.getElementById("main_card" + id).checked = true;
				}
				else
				{
					document.getElementById("main_card" + id).checked = false;
				}
			}
			
			if(backupCardInfo[count++] == 1)
			{
				if(language == 0)
				{
					document.getElementById("bckup_enable_1_n").value = "Disabled";
				}
				else
				{
					document.getElementById("bckup_enable_1_n").value = "不使能";
				}
			}
			else
			{
				if(language == 0)
				{
					document.getElementById("bckup_enable_1_n").value = "Enabled";
				}
				else
				{
					document.getElementById("bckup_enable_1_n").value = "使能";
				}
			}
			document.getElementById("bac_status_1_n").innerHTML = backupCardInfo[count++];

			for(i = 0; i < SYSTEM_SWITCH_CONDITION; i++)
			{
				id = i + 1;
				if(backupCardInfo[count++] == 1)
				{
					document.getElementById("switch_condition" + id).checked = true;
				}
				else
				{
					document.getElementById("switch_condition" + id).checked = false;
				}
			}
			
			for(i = 0; i < switchCondInp.length; i++)
			{
				if(switchCondInp[i].value == backupCardInfo[count])
				{
					switchCondInp[i].checked = true;
					break;
				}
			}
			count++;
			
			for(i = 0; i < switchCondOutp.length; i++)
			{
				if(switchCondOutp[i].value == backupCardInfo[count])
				{
					switchCondOutp[i].checked = true;
					break;
				}
			}
			count++;
			
			disablebckfield(backupCardInfo[0]);
			
			/*板卡备份和设备备份取消互斥关系
			deviceBckupMode = backupCardInfo[count];
			if(deviceBckupMode != 0)
			{
				backupMode[0].checked = true;
				backupMode[1].disabled = true;
				backupMode[2].disabled = true;
				disablebckfield(BACKUP_DISABLED);
			}
			*/
			document.body.style.cursor = "auto";
			window.status = "Done";
		}
	}
	
	xmlhttp.send(getParams);
	return false;
}

function DisableApply()
{
	disabledButton(document.getElementById("Apply"), true);
}

function EnableApply()
{
	disabledButton(document.getElementById("Apply"), false);
}

function ResetSetArrays()
{
	bck_mode_set = 0;
	
	bck_pair_set[0] = 0;
	bck_pair_set[1] = 0;
	
	main_card_set[0] = 0;
	main_card_set[1] = 0;
	main_card_set[2] = 0;

	for(i = 0; i < SYSTEM_SWITCH_CONDITION; i++)
	{
		switch_cond_set[i] = 0;
	}
	
	switch_cond_inp_set = 0;
	switch_cond_outp_set = 0;
}

function PageLoadHandler()
{
	DisableApply();
	//disabledButton(document.getElementById("sync_param"), false);
	document.body.style.cursor = "wait";
	window.status = "Retrieving data, please wait...";
	GetCardBackup();
	ResetSetArrays();
}

function pageRefresh()
{
	PageLoadHandler();
}

window.onload = function()
{
	var thisForm = document.getElementById("cardBackup");
	backupMode = thisForm.backup_mode;
	switchCondInp = thisForm.switch_cond_inp;
	switchCondOutp = thisForm.switch_cond_outp;
	
	language = document.getElementById("language").value;
	
	var apply = document.getElementById("Apply");
	applyDispay(parent.group, apply);
	for(i=0; i<2; i++)
	{
		id = i + 1;
		var enableBtn = document.getElementById("enableRow" + id);
		var syncBtn = document.getElementById("syncRow" + id);
		var revertBtn = document.getElementById("revertRow" + id);
		applyDispay(parent.group, enableBtn);
		applyDispay(parent.group, syncBtn);
		applyDispay(parent.group, revertBtn);
	}
	
	PageLoadHandler();
}

function BckPairChange(comp)
{
	EnableApply();
	for(i=0; i<2; i++)
	{
		id = i + 1;
		if(comp.id == "backup_pair" + id)
		{
			bck_pair_set[i] = 1;
			/*
			if(comp.checked == true)
			{
				disableBckupBtn(id, false);
			}
			else
			{
				disableBckupBtn(id, true);
			}
			*/
		}
	}
}

function MainCardChange(comp)
{
	EnableApply();
	for(i=0; i<3; i++)
	{
		id = i + 1;
		if(comp.id == "main_card" + id)
		{
			main_card_set[i] = 1;
			/*
			if(comp.checked == true)
			{
				disableBckupBtn(3, false);
			}
			else
			{
				disableBckupBtn(3, true);
			}
			*/
		}
	}
}

function SwitchCondChange(comp)
{
	EnableApply();
	for(i=0; i<SYSTEM_SWITCH_CONDITION; i++)
	{
		id = i + 1;
		if(comp.id == "switch_condition" + id)
		{
			switch_cond_set[i] = 1;
		}
	}
}

function SwitchCondInpChange(value)
{
	EnableApply();
	switch_cond_inp_set = 1;
	switchCondInpVal = value;
}

function SwitchCondOutpChange(value)
{
	EnableApply();
	switch_cond_outp_set = 1;
	switchCondOutpVal = value;
}

function SetCardBackup()
{
	DisableApply();
	document.body.style.cursor = "wait";
	window.status = "Updating card backup information, please wait...";

	var getParams = "type=26&cmd=2";
	var backupEnabledVal;
	var mainCardVal = new Array(3);
	var switchCondVal;
	var bacModeVal;

	for(i = 0; i < backupMode.length; i++)
	{
		if(backupMode[i].checked == true)
		{
			bacModeVal = backupMode[i].value;
			break;
		}
	}
	if(bck_mode_set == 1)
	{
		getParams = getParams + "&" + "backupMode=" + bacModeVal;
	}
	
	if(bacModeVal == BACKUP_1_1)
	{
		for(i = 0; i < 2; i++)
		{
			if(bck_pair_set[i] == 1)
			{
				id = i + 1;
				if(document.getElementById("backup_pair" + id).checked == true)
				{
					backupEnabledVal = 1;
				}
				else
				{
					backupEnabledVal = 0;
				}
				getParams = getParams + "&bckEnabledPair" + id + "=" + backupEnabledVal;
			}
		}
	}
	else if(bacModeVal == BACKUP_1_N)
	{
		for(i = 0; i < 3; i++)
		{
			if(main_card_set[i] == 1)
			{
				id = i + 1;
				if(document.getElementById("main_card" + id).checked == true)
				{
					mainCardVal[i] = 1;
				}
				else
				{
					mainCardVal[i] = 0;
				}
				getParams = getParams + "&mainCardSel" + id + "=" + mainCardVal[i];
			}
		}
	}
	
	if((bacModeVal == BACKUP_1_1) || (bacModeVal == BACKUP_1_N))
	{
		for(i = 0; i < SYSTEM_SWITCH_CONDITION; i++)
		{
			if(switch_cond_set[i] == 1)
			{
				id = i + 1;
				if(document.getElementById("switch_condition" + id).checked == true)
				{
					switchCondVal = 1;
				}
				else
				{
					switchCondVal = 0;
				}
				getParams = getParams + "&switch_condition" + id + "=" + switchCondVal;
			}
		}
		
		if(switch_cond_inp_set == 1)
		{
			for(i = 0; i < switchCondInp.length; i++)
			{
				if(switchCondInp[i].checked == true)
				{
					switchCondInpVal = switchCondInp[i].value;
					break;
				}
			}
			getParams = getParams + "&switch_cond_inp=" + switchCondInpVal;
		}
		
		if(switch_cond_outp_set == 1)
		{
			for(i = 0; i < switchCondOutp.length; i++)
			{
				if(switchCondOutp[i].checked == true)
				{
					switchCondOutpVal = switchCondOutp[i].value;
					break;
				}
			}
			getParams = getParams + "&switch_cond_outp=" + switchCondOutpVal;
		}
	}

	var xmlhttp = getHTTPObject();
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			if(xmlhttp.responseText.match("setParamUnsuccessful"))
			{
				if(language == 0)
				{
					alert("Card backup configuration updated failed!");
				}
				else
				{
					alert("卡备份参数设置失败！");
				}
			}
			else
			{
				if(language == 0)
				{
					alert("Card backup configuration updated successfully.");
				}
				else
				{
					alert("卡备份参数已设置成功。");
				}
			}
			PageLoadHandler();
		}
	}
	xmlhttp.send(getParams);
	return true;
}

function BckupEnable(index)
{
	var confirmTxt;
	var alertTxt;
	var syncFlag = 0;
	var obj;
	var xmlhttp = getHTTPObject();
	var getParams = "type=26&cmd=2&";

	if(index == 3)
	{
		id = "_1_n";
		IdStr = "N";
	}
	else
	{
		id = index;
		IdStr = index;
	}
	obj = document.getElementById("bckup_enable" + id);
	
	if(language == 0)
	{
		if(obj.value == "Enabled")
		{
			obj.value = "Disabled";
			confirmTxt = "Whether synchronize backup parameters?";
			if(confirm(confirmTxt))
			{
				syncFlag = 1;
				getParams = getParams + "bckupEnable" + IdStr + "=1&syncParam" + IdStr + "=1";
			}
			else
			{
				getParams = getParams + "bckupEnable" + IdStr + "=1";
			}
		}
		else
		{
			obj.value = "Enabled";
			getParams = getParams + "bckupEnable" + IdStr + "=0";
		}
		alertTxt = "Card backup configuration updated successfully.";
	}
	else
	{
		if(obj.value == "使能")
		{
			obj.value = "不使能";
			confirmTxt = "是否同步备份参数？";
			if(confirm(confirmTxt))
			{
				syncFlag = 1;
				getParams = getParams + "bckupEnable" + IdStr + "=1&syncParam" + IdStr + "=1";
			}
			else
			{
				getParams = getParams + "bckupEnable" + IdStr + "=1";
			}
		}
		else
		{
			obj.value = "使能";
			getParams = getParams + "bckupEnable" + IdStr + "=0";
		}	
		alertTxt = "卡备份参数已设置成功。";
	}
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			if(syncFlag == 1)
			{
				if(xmlhttp.responseText.match("bckupCardInuse"))
				{
					if(language == 0)
					{
						alert("Backup card is in use,can't synchronize parameters!");
					}
					else
					{
						alert("备卡正在使用，不能同步参数！");
					}
					PageLoadHandler();
				}
				else
				{
					parent.lockType = parent.SYNCPARAMLOCK;
					parent.LockUI(parent.lockType);
					querySyncStatus();
				}
			}
			else
			{
				
			}
		}
	}
	
	xmlhttp.send(getParams);
	return true;	
}

function querySyncStatus()
{
	var getParams;
	var xmlhttp = getHTTPObject();
	
	getParams = "type=26&cmd=1&synStatus=1";
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			if(xmlhttp.responseText.match("synSuccessful"))
			{
				if(language == 0)
				{
					alert("Synchronous backup command has been issued, please view the Web status.");
					url = "../asp/main.asp?nodeId=" + parent.curTree.getSelectedNodes()[0].id;
				}
				else
				{
					alert("同步备份指令已经下发,请查看web状态。");
					url = "../asp/main_cn.asp?nodeId=" + parent.curTree.getSelectedNodes()[0].id;
				}
				window.parent.location.replace(url);
			}
			else if(xmlhttp.responseText.match("synUnsuccessful"))
			{
				if(language == 0)
				{
					alert("Main card param is not ready, please wait for a moment and try again!");
				}
				else
				{
					alert("主卡参数没准备好，请稍候再同步备份参数！");
				}
				PageLoadHandler();
			}
			else
			{
				//xmlhttp.abort();
				setTimeout(function(){querySyncStatus()}, 5000);
			}
		}
	}
	
	xmlhttp.send(getParams);
	return true;
}

function SyncParam(index)
{
	var url;
	var getParams;
	var xmlhttp = getHTTPObject();
	
	disableBckupBtn(index, true);

	if(index == 3)
	{
		IdStr = "N";
	}
	else
	{
		IdStr = index;
	}
	getParams = "type=26&cmd=2&syncParam" + IdStr + "=1";
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			if(xmlhttp.responseText.match("bckupCardInuse"))
			{
				if(language == 0)
				{
					alert("Backup card is in use,can't synchronize parameters!");
				}
				else
				{
					alert("备卡正在使用，不能同步参数！");
				}
				PageLoadHandler();
			}
			else
			{
				parent.lockType = parent.SYNCPARAMLOCK;
				parent.LockUI(parent.lockType);
				querySyncStatus();
			}
		}
	}
	xmlhttp.send(getParams);
	return true;
}

function RevertCardBackup(index)
{
	var getParams;
	var confirmTxt;
	var enableStr;
	var disableStr;
	var alertTxt;
	var IdStr;
	var xmlhttp = getHTTPObject();
	
	if(index == 3)
	{
		id = "_1_n";
		IdStr = "N";
	}
	else
	{
		id = index;
		IdStr = index;
	}

	if(language == 0)
	{
		confirmTxt = "Please make sure the main card is normal.";
		enableStr = "Enabled";
		disableStr = "Disabled";
		//alertTxt = "Backup is not enabled,card revert failed!";
	}
	else
	{
		confirmTxt = "请确定主路是否正常。";
		enableStr = "使能";
		disableStr = "不使能";
		//alertTxt = "备份正在使能，回切失败！";
	}
	
	if(confirm(confirmTxt))
	{
		//if(document.getElementById("bckup_enable" + id).value == disableStr)
		//{
		//	alert(alertTxt);
		//}
		//else
		//{
			getParams = "type=26&cmd=2&cardRevrt" + IdStr + "=1";
			
			xmlhttp.open("POST", "/goform/formIPQAM", true);
			xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
			xmlhttp.setRequestHeader("Content-length", getParams.length);
			
			xmlhttp.onreadystatechange = function()
			{
				if(xmlhttp.readyState == 4)
				{
					if(xmlhttp.responseText.match("bckupCardUnused"))
					{
						if(language == 0)
						{
							alert("Backup Card is unused,card revert failed.");
						}
						else
						{
							alert("备卡不在使用，回切失败。");
						}
					}
					else if(xmlhttp.responseText.match("successful"))
					{
						if(language == 0)
						{
							alert("Card revert successfully.");
						}
						else
						{
							alert("卡回切成功。");
						}
					}
					else
					{
						if(language == 0)
						{
							alert("Card revert failed!");
						}
						else
						{
							alert("卡回切失败！");
						}
					}
					PageLoadHandler();
				}
			}
			xmlhttp.send(getParams);
			return true;
		//}
	}
	else
	{
		PageLoadHandler();
	}
}